/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import com.gprinter.utils.BitmapUtils;

public class PicFromPrintUtils {
    public static byte[] draw2PxPoint(Bitmap bit) {
        byte[] data = new byte[16290];
        int k = 0;
        for (int j = 0; j < 15; ++j) {
            data[k++] = 27;
            data[k++] = 42;
            data[k++] = 33;
            data[k++] = 104;
            data[k++] = 1;
            for (int i = 0; i < 360; ++i) {
                for (int m = 0; m < 3; ++m) {
                    for (int n = 0; n < 8; ++n) {
                        byte b = PicFromPrintUtils.px2Byte(i, j * 24 + m * 8 + n, bit);
                        int n2 = k;
                        data[n2] = (byte)(data[n2] + (data[k] + b));
                    }
                    ++k;
                }
            }
            data[k++] = 10;
        }
        return data;
    }

    public static byte[] pic2PxPoint(Bitmap bitmap, int printWidth) {
        int width = (printWidth + 7) / 8 * 8;
        int height = bitmap.getHeight() * width / bitmap.getWidth();
        Bitmap bit = BitmapUtils.resizeImage(bitmap, width, height);
        int cmdHead = bit.getHeight() / 8 * 5;
        int pixNum = bit.getHeight() / 8 * 3 * bit.getWidth();
        byte[] data = new byte[pixNum + cmdHead];
        int k = 0;
        for (int i = 0; i < bit.getHeight() / 24; ++i) {
            data[k++] = 27;
            data[k++] = 42;
            data[k++] = 33;
            data[k++] = (byte)(bit.getWidth() % 256);
            data[k++] = (byte)(bit.getWidth() / 256);
            for (int x = 0; x < bit.getWidth(); ++x) {
                for (int m = 0; m < 3; ++m) {
                    byte[] by = new byte[8];
                    for (int n = 0; n < 8; ++n) {
                        byte b;
                        by[n] = b = PicFromPrintUtils.px2Byte(x, i * 24 + m * 8 + 7 - n, bit);
                    }
                    data[k] = (byte)PicFromPrintUtils.changePointPx1(by);
                    ++k;
                }
            }
            data[k++] = 10;
        }
        return data;
    }

    public static byte[] pic8PxPoint(Bitmap bitmap, int printWidth) {
        int width = (printWidth + 7) / 8 * 8;
        int height = bitmap.getHeight() * width / bitmap.getWidth();
        Bitmap bit = BitmapUtils.resizeImage(bitmap, width, height);
        int cmdHead = bit.getHeight() / 8 * 7;
        int pixNum = bit.getHeight() / 8 * 3 * bit.getWidth();
        byte[] data = new byte[pixNum + cmdHead];
        int k = 0;
        for (int i = 0; i < bit.getHeight() / 8; ++i) {
            data[k++] = 27;
            data[k++] = 42;
            data[k++] = 0;
            data[k++] = (byte)(bit.getWidth() % 256);
            data[k++] = (byte)(bit.getWidth() / 256);
            for (int x = 0; x < bit.getWidth(); ++x) {
                byte[] by = new byte[8];
                for (int n = 0; n < 8; ++n) {
                    byte b;
                    by[n] = b = PicFromPrintUtils.px2Byte(x, i * 8 + 7 - n, bit);
                }
                data[k] = (byte)PicFromPrintUtils.changePointPx1(by);
                ++k;
            }
            data[k++] = 27;
            data[k++] = 74;
            data[k++] = 15;
        }
        return data;
    }

    public static byte px2Byte(int x, int y, Bitmap bit) {
        int blue;
        int green;
        int pixel = bit.getPixel(x, y);
        int red = (pixel & 0xFF0000) >> 16;
        int gray = PicFromPrintUtils.RGB2Gray(red, green = (pixel & 0xFF00) >> 8, blue = pixel & 0xFF);
        byte b = gray < 128 ? (byte)1 : 0;
        return b;
    }

    private static int RGB2Gray(int r, int g, int b) {
        int gray = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
        return gray;
    }

    public static Bitmap compressPic(Bitmap bitmapOrg) {
        int width = bitmapOrg.getWidth();
        int height = bitmapOrg.getHeight();
        int newWidth = 360;
        int newHeight = 360;
        Bitmap targetBmp = Bitmap.createBitmap((int)newWidth, (int)newHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas targetCanvas = new Canvas(targetBmp);
        targetCanvas.drawColor(-1);
        targetCanvas.drawBitmap(bitmapOrg, new Rect(0, 0, width, height), new Rect(0, 0, newWidth, newHeight), null);
        return targetBmp;
    }

    public static Bitmap compressBitmap(Bitmap bitmapOrg) {
        int width = bitmapOrg.getWidth();
        int height = bitmapOrg.getHeight();
        int newWidth = 360;
        int newHeight = 360;
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmapOrg, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    public static int changePointPx1(byte[] arry) {
        int v = 0;
        for (int j = 0; j < arry.length; ++j) {
            if (arry[j] != 1) continue;
            v |= 1 << j;
        }
        return v;
    }

    public byte changePointPx(byte[] arry) {
        byte v = 0;
        for (int i = 0; i < 8; ++i) {
            v = (byte)(v + (v + arry[i]));
        }
        return v;
    }

    public byte[] getPicPx(Bitmap bitmap) {
        int[] pixels = new int[bitmap.getWidth() * bitmap.getHeight()];
        bitmap.getPixels(pixels, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        for (int i = 0; i < pixels.length; ++i) {
            int clr = pixels[i];
            int red = (clr & 0xFF0000) >> 16;
            int green = (clr & 0xFF00) >> 8;
            int blue = clr & 0xFF;
            System.out.println("r=" + red + ",g=" + green + ",b=" + blue);
        }
        return null;
    }
}

